include:
  - nginx
  - nodejs
  - python

www-data:
  user.present:
    - groups:
      - vagrant
    - remove_groups: False

/vagrant/static:
  file.directory:
    - user: vagrant
    - group: vagrant
# fails on mac ...
#    - mode: 0775

bower:
  npm.installed:
    - require:
      - pkg: npm

/etc/nginx/sites-available/default:
  file.managed:
    - source: salt://playground/nginx.conf
    - user: www-data
    - group: www-data
    - mode: 0400

/etc/nginx/sites-enabled/default:
  file.symlink:
    - target: /etc/nginx/sites-available/default
    - require:
      - file:  /etc/nginx/sites-available/default

extend:
  nginx:
    service:
      - watch:
        - file: /etc/nginx/sites-available/default
        - file: /etc/nginx/sites-enabled/default
        - user: www-data
